/*
 * DataUtil.java
 *
 * Created on June 14, 2006, 9:19 PM
 */

package ags.communication;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

/**
 * Collection of miscellaneous text formatting and other routines used by the host utilities.
 * @author Administrator
 */
public class DataUtil {
    
    /** Creates a new instance of DataUtil */
    private  DataUtil() {}
    
    /**
     * Strip off apple high-order text
     * @param in text to strip
     * @return normalized ascii text (hopefully)
     */
    public static String convertFromAppleText(String in) {
        byte string[] = in.getBytes();
        StringBuffer out = new StringBuffer();
        for(int i = 0; i < in.length(); i++)
            out.append(new String(new byte[] {
                (byte)(string[i] & 0x7f)
            }));
        
        return out.toString();
    }
    
    /**
     * Convert a string of data to hexidecimal equivilants.  Useful for writing text directly to the screen.
     * @param in text
     * @return string of hex digits ready to be typed to the apple
     */
    public static String asAppleScreenHex(String in) {
        StringBuffer out = new StringBuffer();
        for(int i = 0; i < in.length(); i++) {
            char c = in.charAt(i);
            if (c >= ' ') out.append(Integer.toHexString(c | 0x80)).append(' ');
        }
        
        return out.toString();
    }
    
    /**
     * Given an int, break it down to a little-endian word (byte array format)
     * @param i int to convert
     * @return little endian byte array
     */
    public static byte[] getWord(int i) {
        byte word[] = new byte[2];
        word[0] = (byte)(i % 256);
        word[1] = (byte)(i / 256);
        return word;
    }
    
    /**
     * Open a file and get its contents as one big string
     * @param file name of file to open
     * @return The file contents as a string
     */
    public static String getFileAsString(String file) {
        InputStream stream = DataUtil.class.getResourceAsStream(file);
        StringBuffer data = new StringBuffer();
        byte buf[] = new byte[256];
        int read = 0;
        try {
            while((read = stream.read(buf)) > 0) {
                String s = new String(buf, 0, read);
                data.append(s);
            }
        } catch(IOException ex) {
            ex.printStackTrace();
        }
        return data.toString();
    }
    
    /**
     * Open a file and get its contents as one big byte array
     * @param file name of file to open
     * @throws java.io.IOException if the file or com port cannot be accessed
     * @return byte array containing file's contents
     */
    public static byte[] getFileAsBytes(String file)
    throws IOException {
        InputStream stream = GenericHost.class.getResourceAsStream(file);
        int size = stream.available();
        ByteBuffer bb = ByteBuffer.allocate(size);
        byte buf[] = new byte[256];
        int read = 0;
        try {
            while((read = stream.read(buf)) > 0)
                bb.put(buf, 0, read);
        } catch(IOException ex) {
            ex.printStackTrace();
        }
        return bb.array();
    }
    
    /**
     * Sleep the current thread for a little while
     * @param time time in ms to wait
     */
    public static void wait(int time) {
        try {
            Thread.sleep(time);
        } catch(InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}
